"""Initialisation

Revision ID: 00000
Revises: 
Create Date: 2022-07-28 09:55:44.452130

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '00000'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('files_filestorages',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('storage_type', sa.Enum('LOCAL', 'NETWORK', name='filestoragetype'), server_default='LOCAL', nullable=False),
    sa.Column('path', sa.String(), nullable=True),
    sa.Column('is_default', sa.Boolean(), server_default='0', nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('node_logs',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('node_name', sa.String(length=120), nullable=True),
    sa.Column('node_class', sa.String(length=120), nullable=True),
    sa.Column('node_fingerprint', sa.String(length=120), nullable=True),
    sa.Column('node_ip', sa.String(length=120), nullable=True),
    sa.Column('node_status', sa.String(length=120), nullable=True),
    sa.Column('request_action', sa.String(length=120), nullable=True),
    sa.Column('request_reply', sa.String(length=120), nullable=True),
    sa.Column('request_status', sa.String(length=120), nullable=True),
    sa.Column('request_on', sqlalchemy_utils.types.arrow.ArrowType(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('nodes',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=64), nullable=True),
    sa.Column('fingerprint', sa.String(length=120), nullable=True),
    sa.Column('class_name', sa.String(length=120), nullable=True),
    sa.Column('workspace', sa.String(length=120), nullable=True),
    sa.Column('network_ip', sa.String(length=64), nullable=True),
    sa.Column('last_request_on', sqlalchemy_utils.types.arrow.ArrowType(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_nodes_name'), 'nodes', ['name'], unique=True)
    op.create_table('users',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('_password_hash', sa.LargeBinary(length=60), nullable=False),
    sa.Column('_pin_hash', sa.LargeBinary(length=60), nullable=True),
    sa.Column('_salt', sa.String(length=128), nullable=True),
    sa.Column('_api_key_hash', sa.String(length=256), nullable=True),
    sa.Column('email', sa.String(length=120), nullable=True),
    sa.Column('firstname', sa.String(length=64), nullable=True),
    sa.Column('lastname', sa.String(length=64), nullable=True),
    sa.Column('organization', sa.String(length=64), nullable=True),
    sa.Column('phone', sa.String(length=64), nullable=True),
    sa.Column('orderlimit', sa.Integer(), nullable=True),
    sa.Column('account_created_date', sqlalchemy_utils.types.arrow.ArrowType(), nullable=True),
    sa.Column('last_login_date', sqlalchemy_utils.types.arrow.ArrowType(), nullable=True),
    sa.Column('password_reset_expired_date', sqlalchemy_utils.types.arrow.ArrowType(), nullable=True),
    sa.Column('password_reset_hash', sa.String(length=128), nullable=True),
    sa.Column('account_verified', sa.Boolean(), nullable=True),
    sa.Column('account_locked', sa.Boolean(), nullable=True),
    sa.Column('ldap', sa.Boolean(), nullable=True),
    sa.Column('ldap_dn', sa.String(length=64), nullable=True),
    sa.Column('ldap_username', sa.String(length=64), nullable=True),
    sa.Column('admin', sa.Boolean(), nullable=True),
    sa.Column('budget', sa.Float(), nullable=True),
    sa.Column('sessionValid', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_users_email'), 'users', ['email'], unique=True)
    op.create_table('files_files',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('file_name', sa.String(), nullable=False),
    sa.Column('display_name', sa.String(), nullable=True),
    sa.Column('workspace', sa.String(), nullable=True),
    sa.Column('uuid_string', sa.String(), nullable=True),
    sa.Column('date_added', sa.DateTime(), nullable=False),
    sa.Column('size_in_bytes', sa.Integer(), nullable=True),
    sa.Column('filestorage_id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('path', sa.String(), nullable=True),
    sa.Column('mime_type', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['filestorage_id'], ['files_filestorages.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('node_settings',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('node_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['node_id'], ['nodes.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('users_delegation',
    sa.Column('delegated_from', sa.Integer(), nullable=True),
    sa.Column('delegated_to', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['delegated_from'], ['users.id'], ),
    sa.ForeignKeyConstraint(['delegated_to'], ['users.id'], )
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('users_delegation')
    op.drop_table('node_settings')
    op.drop_table('files_files')
    op.drop_index(op.f('ix_users_email'), table_name='users')
    op.drop_table('users')
    op.drop_index(op.f('ix_nodes_name'), table_name='nodes')
    op.drop_table('nodes')
    op.drop_table('node_logs')
    op.drop_table('files_filestorages')
    # ### end Alembic commands ###
