# Modular Policy Example

This folder includes an example of how to build a modular, template-based set of policies. Modular
templates means we only need to manage a unique set applications. The rest of the relationships can be
loaded using the namespaces generated by this original set of policies.

## Installation

1. Create a `staging` and `production` namespace:
    ```sh
    $ ./cli conjur policy load -b root -f policy/modular/root.yml
    ```
2. Create namespaces for each of our applications (`my-app-1..my-app-6`) in the staging namespace:
    ```sh
    $ ./cli conjur policy load -b staging -f policy/modular/apps/applications.yml
    ```
3. Create our first application `my-app-1`, in the staging environment:
    ```sh
    $ ./cli conjur policy load -b staging/my-app-1 -f policy/modular/apps/generic-application.yml
    ```

4. Create our a database connection for our application `my-app-1`, in the staging environment:
    ```sh
    $ ./cli conjur policy load -b staging/my-app-1 -f policy/modular/services/pg-database.yml
    ```

5. Grant our layer permission to retrieve database connection information:
    ```sh
    $ ./cli conjur policy load -b staging/my-app-1 -f policy/modular/pg-entitlement.yml
    ```

6. Now we can set the database connection information:
    ```sh
    $ ./cli conjur variable set -i staging/my-app-1/postgres-database/password -v super-secret
    ...
    ```

With the above, we've created an application (`staging/my-app-1`), created a database (`staging/my-app-1/postgres-database`),
and granted the application read access to the application layer.
