#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for iosxr_ospfv3
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type

DOCUMENTATION = """
module: iosxr_ospfv3
version_added: 1.1.0
short_description: Resource module to configure OSPFv3.
description:
  - This module manages global ospfv3 configuration on devices running Cisco IOS-XR
author: Rohit Thakur (@rohitthakur2590)
notes:
  - This module works with connection C(network_cli). See L(the IOS-XR Platform Options,../network/user_guide/platform_iosxr.html)
options:
  running_config:
    description:
      - This option is used only with state I(parsed).
      - The value of this option should be the output received from the IOS-XR device
        by executing the command B(show running-config router ospfv3).
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into Ansible structured data as per the resource module's argspec
        and the value is then returned in the I(parsed) key within the result.
    type: str
  config:
    description: A list of ospfv3 process configuration
    type: dict
    suboptions:
      processes:
        description: A list of ospfv3 instances configuration
        type: list
        elements: dict
        suboptions:
          process_id:
            description: The OSPFv3 Process ID
            type: str
            required: true
          address_family_unicast:
            description: Enable unicast topology for ipv4 address family
            type: bool
          authentication:
            description: Enable authentication
            type: dict
            suboptions:
              disable:
                description: Do not authenticate OSPFv3 packets
                type: bool
                default: false
              ipsec:
                description: Specify IPSec AH authentication attributes
                type: dict
                suboptions:
                  spi:
                    description: Specify the Security Parameter Index value
                    type: int
                  algorithim_type:
                    description: Specify the type of algorithim
                    type: str
                    choices: ["md5", "sha1"]
                  key:
                    description: Specify key
                    type: str
                  clear_key:
                    description: Specify key in cleartext form
                    type: str
                  password_key:
                    description: Specify key in encrypted form
                    type: str
          auto_cost:
            description: Calculate ospfv3 interface cost according to bandwidth
            type: dict
            suboptions:
              reference_bandwidth:
                description: Specify reference bandwidth in megabits per sec
                type: int
              disable:
                description: Assign ospfv3 cost based on interface type
                type: bool
          bfd:
            description: Configure BFD parameters
            type: dict
            suboptions:
              fast_detect:
                description: Configure fast detection
                type: dict
                suboptions:
                  set:
                    description: Enable fast detection only
                    type: bool
                  strict_mode:
                    description: Hold down neighbor session until BFD session is up
                    type: bool
              minimum_interval:
                description: Hello interval in milli-seconds
                type: int
              multiplier:
                description: Detect multiplier
                type: int
          areas:
            description: Configure ospfv3 areas' properties
            type: list
            elements: dict
            suboptions:
              area_id:
                description: Area ID as IP address or integer
                type: str
                required: True
              authentication:
                description: Enable authentication
                type: dict
                suboptions:
                  disable:
                    description: Do not authenticate OSPFv3 packets
                    type: bool
                    default: false
                  ipsec:
                    description: Specify IPSec AH authentication attributes
                    type: dict
                    suboptions:
                      spi:
                        description: Specify the Security Parameter Index value
                        type: int
                      algorithim_type:
                        description: Specify the type of algorithim
                        type: str
                        choices: ["md5", "sha1"]
                      key:
                        description: Specify key
                        type: str
                      clear_key:
                        description: Specify key in cleartext form
                        type: str
                      password_key:
                        description: Specify key in encrypted form
                        type: str
              bfd:
                description: Configure BFD parameters
                type: dict
                suboptions:
                  fast_detect:
                    description: Configure fast detection
                    type: dict
                    suboptions:
                      set:
                        description: Enable fast detection only
                        type: bool
                      strict_mode:
                        description: Hold down neighbor session until BFD session is up
                        type: bool
                  minimum_interval:
                    description: Hello interval in milli-seconds
                    type: int
                  multiplier:
                    description: Detect multiplier
                    type: int
              cost:
                description: Interface cost
                type: int
              database_filter:
                description: Filter LSAs during synchronization and flooding
                type: dict
                suboptions:
                  all_outgoing_lsa:
                    description: Filter all outgoing LSA
                    type: bool
              dead_interval:
                description: Interval after which a neighbor is declared dead
                type: int
              default_cost:
                description: Set the summary default-cost of a NSSA/stub area. Stub's advertised external route metric
                type: int
              demand_circuit:
                description: Enable/Disable ospfv3 demand circuit
                type: bool
              distrinbute_rib_prefix_list_name:
                description: Filter LSAs during synchronization and flooding
                type: str
              fast_reroute:
                description: Specify IP Fast Reroute
                type: dict
                suboptions:
                  disabled:
                    description: Disable IP fast reroute
                    type: bool
                  per_link:
                    description: Specify per-prefix computation
                    type: dict
                    suboptions:
                      information_type:
                        description: Specify per-link LFA exclusion or FRR LFA candidate information
                        type: str
                        choices: ["exclude", "lfa_candidate"]
                      use_candidate_only:
                        description: Enable/Disable backup selection from candidate-list only
                        type: bool
                      interface:
                        description: Specify Per-link LFA exclusion information
                        type: dict
                        suboptions:
                          bvi:
                            description: Specify Bridge-Group Virtual Interface
                            type: list
                            elements: int
                          bundle_ether:
                            description: Specify Aggregated Ethernet interface(s)
                            type: list
                            elements: int
                          pos_int:
                            description: Specify Aggregated pos interface(s)
                            type: list
                            elements: int
                          fast_ethernet:
                            description: Specify FastEthernet/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          fiftygige:
                            description: Specify FiftyGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          fortygige:
                            description: Specify FortyGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          fourhundredgige:
                            description: Specify FourHundredGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          gigabitethernet:
                            description: Specify GigabitEthernet/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          hundredgige:
                            description: Specify HundredGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          mgmteth:
                            description: Specify MgmtEth/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          multilink:
                            description: Specify Multilink network interface(s)
                            type: list
                            elements: str
                          pw_ether:
                            description: Specify PWHE Ethernet Interface
                            type: list
                            elements: int
                          pw_iw:
                            description: Specify PWHE VC11 IP Interworking Interface
                            type: list
                            elements: int
                          srp:
                            description: Specify SRP interface(s)
                            type: list
                            elements: str
                          serial:
                            description: Specify Serial network interface(s)
                            type: list
                            elements: str
                          tengige:
                            description: Specify TenGigabitEthernet/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          twentyfivegige:
                            description: Specify TwentyFiveGigabitEthernet/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          twohundredgige:
                            description: Specify TwoHundredGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          nve:
                            description: Specify Network Virtualization Endpoint Interface(s)
                            type: list
                            elements: int
                          tunnel_ip:
                            description: Specify GRE/IPinIP Tunnel Interface(s)
                            type: list
                            elements: int
                          tunnel_ipsec:
                            description: Specify IPSec Tunnel interface(s)
                            type: list
                            elements: int
                          tunnel_mte:
                            description: Specify MPLS Traffic Engineering P2MP Tunnel interface(s)
                            type: list
                            elements: int
                          tunnel_mpls:
                            description: MPLS Transport Protocol Tunnel interface
                            type: int
                  per_prefix:
                    description: Specify per-prefix computation
                    type: dict
                    suboptions:
                      information_type:
                        description: Specify per_prefix LFA exclusion or FRR LFA candidate information
                        type: str
                        choices: ["exclude", "lfa_candidate"]
                      use_candidate_only:
                        description: Enable/Disable backup selection from candidate-list only
                        type: bool
                      interface:
                        description: Specify Per-link LFA exclusion information
                        type: dict
                        suboptions:
                          bvi:
                            description: Specify Bridge-Group Virtual Interface
                            type: list
                            elements: int
                          bundle_ether:
                            description: Specify Aggregated Ethernet interface(s)
                            type: list
                            elements: int
                          pos_int:
                            description: Specify Aggregated pos interface(s)
                            type: list
                            elements: int
                          fast_ethernet:
                            description: Specify FastEthernet/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          fiftygige:
                            description: Specify FiftyGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          fortygige:
                            description: Specify FortyGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          fourhundredgige:
                            description: Specify FourHundredGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          gigabitethernet:
                            description: Specify GigabitEthernet/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          hundredgige:
                            description: Specify HundredGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          mgmteth:
                            description: Specify MgmtEth/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          multilink:
                            description: Specify Multilink network interface(s)
                            type: list
                            elements: str
                          pw_ether:
                            description: Specify PWHE Ethernet Interface
                            type: list
                            elements: int
                          pw_iw:
                            description: Specify PWHE VC11 IP Interworking Interface
                            type: list
                            elements: int
                          srp:
                            description: Specify SRP interface(s)
                            type: list
                            elements: str
                          serial:
                            description: Specify Serial network interface(s)
                            type: list
                            elements: str
                          tengige:
                            description: Specify TenGigabitEthernet/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          twentyfivegige:
                            description: Specify TwentyFiveGigabitEthernet/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          twohundredgige:
                            description: Specify TwoHundredGigE/IEEE 802.3 interface(s)
                            type: list
                            elements: str
                          nve:
                            description: Specify Network Virtualization Endpoint Interface(s)
                            type: list
                            elements: int
                          tunnel_ip:
                            description: Specify GRE/IPinIP Tunnel Interface(s)
                            type: list
                            elements: int
                          tunnel_ipsec:
                            description: Specify IPSec Tunnel interface(s)
                            type: list
                            elements: int
                          tunnel_mte:
                            description: Specify MPLS Traffic Engineering P2MP Tunnel interface(s)
                            type: list
                            elements: int
                          tunnel_mpls:
                            description: MPLS Transport Protocol Tunnel interface
                            type: int
              flood_reduction:
                description: Enable/Disable flood reduction
                type: bool
              hello_interval:
                description: Specify Time between HELLO packets
                type: int
              instance_id:
                description: Specify instance ID
                type: int
              mtu_ignore:
                description: Enable/Disable ignoring of MTU in DBD packets
                type: bool
              mpls_ldp_sync:
                description: Enable/Disable MPLS LDP Sync
                type: bool
              network:
                description: Specify Network type
                type: str
                choices: ["broadcast", "non-broadcast", "point-to-multipoint", "point-to-point"]
              nssa:
                description: NSSA settings for the area
                type: dict
                suboptions:
                  set:
                    description: Configure area as NSSA
                    type: bool
                  default_information_originate:
                    description: Originate default Type 7 LSA
                    type: dict
                    suboptions:
                      set:
                        description: Set nssa to default information originate
                        type: bool
                      metric:
                        description: ospfv3 default metric
                        type: int
                      metric_type:
                        description: Metric type for default routes
                        type: int
                  no_redistribution:
                    description: Do not send redistributed LSAs into NSSA area
                    type: bool
                  no_summary:
                    description: Do not send summary LSAs into NSSA area
                    type: bool
                  translate:
                    description: Translate LSA
                    type: dict
                    suboptions:
                      type7:
                        description: Translate from Type 7 to Type 5
                        type: dict
                        suboptions:
                          always:
                            description: Always translate LSAs
                            type: bool
                            required: true
              packet_size:
                description: Specify limit size of OSPFv3 packets
                type: int
              passive:
                description: Enable/Disable routing updates on an interface
                type: bool
              prefix_suppression:
                description: Hide all transit addresses on this interface
                type: bool
              priority:
                description: Specify Router priority
                type: int
              ranges:
                description: Summarize routes matching address/mask (border routers only)
                type: list
                elements: dict
                suboptions:
                  address:
                    description: IP in Prefix format (X:X::X/length)
                    type: str
                    required: True
                  cost:
                    description: Specify user specified metric for this range
                    type: int
                  advertise:
                    description: Advertise this range (default)
                    type: bool
                  not_advertise:
                    description: DoNotAdvertise this range
                    type: bool
              retransmit_interval:
                  description: Specify Delay between LSA retransmissions
                  type: int
              stub:
                description: Settings for configuring the area as a stub
                type: dict
                suboptions:
                  set:
                    description: Configure the area as a stub
                    type: bool
                  no_summary:
                    description: Do not send summary LSA into stub area
                    type: bool
              transmit_delay:
                description: Specify estimated time needed to send link-state update packet
                type: int
              virtual_link:
                description: Define a virtual link
                type: list
                elements: dict
                suboptions:
                  id:
                    description: Router-ID of virtual link neighbor (A.B.C.D)
                    type: str
                    required: True
                  authentication:
                    description: Enable authentication
                    type: dict
                    suboptions:
                      disable:
                        description: Do not authenticate OSPFv3 packets
                        type: bool
                        default: false
                      ipsec:
                        description: Specify IPSec AH authentication attributes
                        type: dict
                        suboptions:
                          spi:
                            description: Specify the Security Parameter Index value
                            type: int
                          algorithim_type:
                            description: Specify the type of algorithim
                            type: str
                            choices: ["md5", "sha1"]
                          key:
                            description: Specify key
                            type: str
                          clear_key:
                            description: Specify key in cleartext form
                            type: str
                          password_key:
                            description: Specify key in encrypted form
                            type: str
                  dead_interval:
                    description: Interval after which a neighbor is declared dead
                    type: int
                  hello_interval:
                    description: Time between HELLO packets
                    type: int
                  retransmit_interval:
                    description: Delay between LSA retransmissions
                    type: int
                  transmit_delay:
                    description: Link state transmit delay
                    type: int
                  encryption:
                    description: Encrypt and authenticate OSPFv3 packets
                    type: dict
                    suboptions:
                      disable:
                        description: Do not encrypt OSPFv3 packets
                        type: bool
                        default: false
                      ipsec:
                        description: Specify IPSec ESP encryption and authentication
                        type: dict
                        suboptions:
                          spi:
                            description: Specify the Security Parameter Index value
                            type: int
                          esp:
                            description: Specify encryption parameters
                            type: dict
                            suboptions:
                              triple_des:
                                description: This specify the triple DES algorithim
                                type: dict
                                suboptions:
                                  key:
                                    description: Cleartext 3DES key
                                    type: str
                                  clear_key:
                                    description: Specify 3DES key in cleartext form
                                    type: str
                                  password_key:
                                    description: Specify 3DES key in encrypted form
                                    type: str
                              aes:
                                description: This specify the aes algorithim
                                type: dict
                                suboptions:
                                  algorithim_type:
                                    description: Specify the bit encryption for aes algorithim
                                    type: str
                                    choices: ["192", "256"]
                                  key:
                                    description: Cleartext AES key
                                    type: str
                                  clear_key:
                                    description: Specify AES key in cleartext form
                                    type: str
                                  password_key:
                                    description: Specify AES key in encrypted form
                                    type: str
                              des:
                                description: This specify the des algorithim
                                type: dict
                                suboptions:
                                  key:
                                    description: Cleartext AES key
                                    type: str
                                  clear_key:
                                    description: Specify AES key in cleartext form
                                    type: str
                                  password_key:
                                    description: Specify AES key in encrypted form
                                    type: str
                              null_encryption:
                                description: Specify null encryption attributes
                                type: dict
                                suboptions:
                                  authentication:
                                    description: Specify authentication parameters
                                    type: dict
                                    suboptions:
                                      algorithim_type:
                                        description: Specify the type of algorithim
                                        type: str
                                        choices: ["md5", "sha1"]
                                      key:
                                        description: Specify key
                                        type: str
                                      clear_key:
                                        description: Specify key in cleartext form
                                        type: str
                                      password_key:
                                        description: Specify key in encrypted form
                                        type: str
              encryption:
                description: Encrypt and authenticate OSPFv3 packets
                type: dict
                suboptions:
                  disable:
                    description: Do not encrypt OSPFv3 packets
                    type: bool
                    default: false
                  ipsec:
                    description: Specify IPSec ESP encryption and authentication
                    type: dict
                    suboptions:
                      spi:
                        description: Specify the Security Parameter Index value
                        type: int
                      esp:
                        description: Specify encryption parameters
                        type: dict
                        suboptions:
                          triple_des:
                            description: This specify the triple DES algorithim
                            type: dict
                            suboptions:
                              key:
                                description: Cleartext 3DES key
                                type: str
                              clear_key:
                                description: Specify 3DES key in cleartext form
                                type: str
                              password_key:
                                description: Specify 3DES key in encrypted form
                                type: str
                          aes:
                            description: This specify the aes algorithim
                            type: dict
                            suboptions:
                              algorithim_type:
                                description: Specify the bit encryption for aes algorithim
                                type: str
                                choices: ["192", "256"]
                              key:
                                description: Cleartext AES key
                                type: str
                              clear_key:
                                description: Specify AES key in cleartext form
                                type: str
                              password_key:
                                description: Specify AES key in encrypted form
                                type: str
                          des:
                            description: This specify the des algorithim
                            type: dict
                            suboptions:
                              key:
                                description: Cleartext AES key
                                type: str
                              clear_key:
                                description: Specify AES key in cleartext form
                                type: str
                              password_key:
                                description: Specify AES key in encrypted form
                                type: str
                          null_encryption:
                            description: Specify null encryption attributes
                            type: dict
                            suboptions:
                              authentication:
                                description: Specify authentication parameters
                                type: dict
                                suboptions:
                                  algorithim_type:
                                    description: Specify the type of algorithim
                                    type: str
                                    choices: ["md5", "sha1"]
                                  key:
                                    description: Specify key
                                    type: str
                                  clear_key:
                                    description: Specify key in cleartext form
                                    type: str
                                  password_key:
                                    description: Specify key in encrypted form
                                    type: str
          capability:
            description: Enable specific OSPFv3 feature
            type: dict
            suboptions:
              type7:
                description: Specify type7 nssa capability
                type: dict
                suboptions:
                  prefer:
                    description: Prefer type7 externals over type5
                    type: bool
                  translate:
                    description: Translate type7 to type5
                    type: bool
          cost:
            description: Specify Interface cost
            type: int
          database_filter:
            description: Filter LSAs during synchronization and flooding
            type: dict
            suboptions:
              all_outgoing_lsa:
                description: Filter all outgoing LSA
                type: bool
          dead_interval:
            description: Interval after which a neighbor is declared dead
            type: int
          default_information_originate:
            description: Control distribution of default information
            type: dict
            suboptions:
              always:
                description: Always advertise default route
                type: bool
              metric:
                description: ospfv3 default metric
                type: int
              metric_type:
                description: ospfv3 metric type for default routes
                type: int
              route_policy:
                description: Apply route-policy to default-information origination
                type: str
              tag:
                description: Set tag for default route
                type: int
              set:
                description: Enable distribution of default route
                type: bool
          default_metric:
            description: Set metric of redistributed routes
            type: int
          demand_circuit:
            description: Enable/Disable ospfv3 demand circuit
            type: bool
          distance:
            description: Define an administrative distance
            type: dict
            suboptions:
              admin_distance:
                description: Administrative distance
                type: int
              ospfv3_distance:
                description: ospfv3 administrative distance
                type: dict
                suboptions:
                  external:
                    description: Distance for external routes
                    type: int
                  inter_area:
                    description: Distance for inter-area routes
                    type: int
                  intra_area:
                    description: Distance for intra-area routes
                    type: int
          distribute_list:
            description: Filter prefixes to/from RIB
            type: dict
            suboptions:
              prefix_list:
                description: Filter prefixes based on an IPv6 prefix-list
                type: list
                elements: str
                suboptions:
                  name:
                    description: Specify Prefix-list name
                    type: str
                  in:
                    description: Filter prefixes installed to RIB
                    type: bool
                  out:
                    description: Filter prefixes redistributed from RIB
                    type: bool
          encryption:
            description: Encrypt and authenticate OSPFv3 packets
            type: dict
            suboptions:
              disable:
                description: Do not encrypt OSPFv3 packets
                type: bool
                default: false
              ipsec:
                description: Specify IPSec ESP encryption and authentication
                type: dict
                suboptions:
                  spi:
                    description: Specify the Security Parameter Index value
                    type: int
                  esp:
                    description: Specify encryption parameters
                    type: dict
                    suboptions:
                      triple_des:
                        description: This specify the triple DES algorithim
                        type: dict
                        suboptions:
                          key:
                            description: Cleartext 3DES key
                            type: str
                          clear_key:
                            description: Specify 3DES key in cleartext form
                            type: str
                          password_key:
                            description: Specify 3DES key in encrypted form
                            type: str
                      aes:
                        description: This specify the aes algorithim
                        type: dict
                        suboptions:
                          algorithim_type:
                            description: Specify the bit encryption for aes algorithim
                            type: str
                            choices: ["192", "256"]
                          key:
                            description: Cleartext AES key
                            type: str
                          clear_key:
                            description: Specify AES key in cleartext form
                            type: str
                          password_key:
                            description: Specify AES key in encrypted form
                            type: str
                      des:
                        description: This specify the des algorithim
                        type: dict
                        suboptions:
                          key:
                            description: Cleartext AES key
                            type: str
                          clear_key:
                            description: Specify AES key in cleartext form
                            type: str
                          password_key:
                            description: Specify AES key in encrypted form
                            type: str
                      null_encryption:
                        description: Specify null encryption attributes
                        type: dict
                        suboptions:
                          authentication:
                            description: Specify authentication parameters
                            type: dict
                            suboptions:
                              algorithim_type:
                                description: Specify the type of algorithim
                                type: str
                                choices: ["md5", "sha1"]
                              key:
                                description: Specify key
                                type: str
                              clear_key:
                                description: Specify key in cleartext form
                                type: str
                              password_key:
                                description: Specify key in encrypted form
                                type: str
          fast_reroute:
            description: Specify IP Fast Reroute
            type: dict
            suboptions:
              disabled:
                description: Disable IP fast reroute
                type: bool
              per_link:
                description: Specify per-prefix computation
                type: dict
                suboptions:
                  information_type:
                    description: Specify per-link LFA exclusion or FRR LFA candidate information
                    type: str
                    choices: ["exclude", "lfa_candidate"]
                  use_candidate_only:
                    description: Enable/Disable backup selection from candidate-list only
                    type: bool
                  interface:
                    description: Specify Per-link LFA exclusion information
                    type: dict
                    suboptions:
                      bvi:
                        description: Specify Bridge-Group Virtual Interface
                        type: list
                        elements: int
                      bundle_ether:
                        description: Specify Aggregated Ethernet interface(s)
                        type: list
                        elements: int
                      pos_int:
                        description: Specify Aggregated pos interface(s)
                        type: list
                        elements: int
                      fast_ethernet:
                        description: Specify FastEthernet/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      fiftygige:
                        description: Specify FiftyGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      fortygige:
                        description: Specify FortyGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      fourhundredgige:
                        description: Specify FourHundredGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      gigabitethernet:
                        description: Specify GigabitEthernet/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      hundredgige:
                        description: Specify HundredGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      mgmteth:
                        description: Specify MgmtEth/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      multilink:
                        description: Specify Multilink network interface(s)
                        type: list
                        elements: str
                      pw_ether:
                        description: Specify PWHE Ethernet Interface
                        type: list
                        elements: int
                      pw_iw:
                        description: Specify PWHE VC11 IP Interworking Interface
                        type: list
                        elements: int
                      srp:
                        description: Specify SRP interface(s)
                        type: list
                        elements: str
                      serial:
                        description: Specify Serial network interface(s)
                        type: list
                        elements: str
                      tengige:
                        description: Specify TenGigabitEthernet/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      twentyfivegige:
                        description: Specify TwentyFiveGigabitEthernet/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      twohundredgige:
                        description: Specify TwoHundredGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      nve:
                        description: Specify Network Virtualization Endpoint Interface(s)
                        type: list
                        elements: int
                      tunnel_ip:
                        description: Specify GRE/IPinIP Tunnel Interface(s)
                        type: list
                        elements: int
                      tunnel_ipsec:
                        description: Specify IPSec Tunnel interface(s)
                        type: list
                        elements: int
                      tunnel_mte:
                        description: Specify MPLS Traffic Engineering P2MP Tunnel interface(s)
                        type: list
                        elements: int
                      tunnel_mpls:
                        description: MPLS Transport Protocol Tunnel interface
                        type: int
              per_prefix:
                description: Specify per-prefix computation
                type: dict
                suboptions:
                  information_type:
                    description: Specify per_prefix LFA exclusion or FRR LFA candidate information
                    type: str
                    choices: ["exclude", "lfa_candidate"]
                  use_candidate_only:
                    description: Enable/Disable backup selection from candidate-list only
                    type: bool
                  interface:
                    description: Specify Per-link LFA exclusion information
                    type: dict
                    suboptions:
                      bvi:
                        description: Specify Bridge-Group Virtual Interface
                        type: list
                        elements: int
                      bundle_ether:
                        description: Specify Aggregated Ethernet interface(s)
                        type: list
                        elements: int
                      post_int:
                        description: Specify Aggregated pos interface(s)
                        type: list
                        elements: int
                      fast_ethernet:
                        description: Specify FastEthernet/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      fiftygige:
                        description: Specify FiftyGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      fortygige:
                        description: Specify FortyGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      fourhundredgige:
                        description: Specify FourHundredGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      gigabitethernet:
                        description: Specify GigabitEthernet/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      hundredgige:
                        description: Specify HundredGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      mgmteth:
                        description: Specify MgmtEth/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      multilink:
                        description: Specify Multilink network interface(s)
                        type: list
                        elements: str
                      pw_ether:
                        description: Specify PWHE Ethernet Interface
                        type: list
                        elements: int
                      pw_iw:
                        description: Specify PWHE VC11 IP Interworking Interface
                        type: list
                        elements: int
                      srp:
                        description: Specify SRP interface(s)
                        type: list
                        elements: str
                      serial:
                        description: Specify Serial network interface(s)
                        type: list
                        elements: str
                      tengige:
                        description: Specify TenGigabitEthernet/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      twentyfivegige:
                        description: Specify TwentyFiveGigabitEthernet/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      twohundredgige:
                        description: Specify TwoHundredGigE/IEEE 802.3 interface(s)
                        type: list
                        elements: str
                      nve:
                        description: Specify Network Virtualization Endpoint Interface(s)
                        type: list
                        elements: int
                      tunnel_ip:
                        description: Specify GRE/IPinIP Tunnel Interface(s)
                        type: list
                        elements: int
                      tunnel_ipsec:
                        description: Specify IPSec Tunnel interface(s)
                        type: list
                        elements: int
                      tunnel_mte:
                        description: Specify MPLS Traffic Engineering P2MP Tunnel interface(s)
                        type: list
                        elements: int
                      tunnel_mpls:
                        description: MPLS Transport Protocol Tunnel interface
                        type: int
          flood_reduction:
            description: Enable/Disable flood reduction
            type: bool
          graceful_restart:
            description: Enable Graceful-Restart
            type: dict
            suboptions:
              set:
                description: Set graceful restart
                type: bool
              helper_disable:
                description: Disable router's helper support level
                type: bool
              min_interval:
                description: Minimum interval between Graceful Restarts
                type: int
              max_interval:
                description: Maximum route lifetime following restart
                type: int
          hello_interval:
            description: Specify Time between HELLO packets
            type: int
          ignore_mospf_type6_lsa:
            description: Ignore MOSPF Type 6 LSA
            type: bool
          instance_id:
            description: Specify instance ID
            type: int
          log_adjacency_changes:
            description: Log adjacency state changes
            type: dict
            suboptions:
              set:
                description: Set log adjacency
                type: bool
              disable:
                description: Disable log adjacency changes
                type: bool
              detail:
                description: Log all state changes
                type: bool
          maximum:
            description: Set OSPFv3 limits
            type: dict
            suboptions:
              interfaces:
                description: Specify limit for number of interfaces
                type: int
              paths:
                description: Specify limit for number of paths
                type: int
              redistributed_prefixes:
                description: Specify limit for number of redistributed prefixes
                type: int
          mpls_ldp_sync:
            description: Enable/Disable MPLS LDP Sync
            type: bool
          mtu_ignore:
            description: Enable/Disable ignoring of MTU in DBD packets
            type: bool
          network:
            description: Specify Network type
            type: str
            choices: ["broadcast", "non-broadcast", "point-to-multipoint", "point-to-point"]
          nsr:
            description: Enable/Disable NSR for all VRFs in this process
            type: bool
          packet_size:
            description: Specify limit size of OSPFv3 packets
            type: int
          passive:
            description: Enable/Disable routing updates on an interface
            type: bool
          prefix_suppression:
            description: Hide all transit addresses on this interface
            type: bool
          priority:
            description: Specify Router priority
            type: int
          protocol_shutdown:
            description: Gracefully shutdown the OSPFv3 protocol
            type: bool
          redistribute:
            description: Redistribute information from another routing Protocol
            type: dict
            suboptions:
              application:
                description: Specify application routes
                type: list
                elements: dict
                suboptions:
                  id:
                    description: OnePK Application name
                    type: str
                    required: true
                  set:
                    description: Set application route
                    type: bool
                  metric:
                    description: Specify metric for redistributed routes
                    type: int
                  metric_type:
                    description: Specify OSPFv3 exterior metric type for redistributed routes
                    type: int
                  route_policy:
                    description: Apply route policy to redistribution
                    type: str
                  tag:
                    description: Set tag for routes redistributed into OSPFv3
                    type: int
              bgp:
                description: Specify bgp routes
                type: list
                elements: dict
                suboptions:
                  id:
                   description: BGP process name
                   type: int
                   required: true
                  set:
                    description: Set bgp route number
                    type: bool
                  metric:
                    description: Specify metric for redistributed routes
                    type: int
                  metric_type:
                    description: Specify OSPFv3 exterior metric type for redistributed routes
                    type: int
                  preserved_med:
                    description: Specify preserve med of BGP routes
                    type: str
                  route_policy:
                    description: Apply route policy to redistribution
                    type: str
                  tag:
                    description: Set tag for routes redistributed into OSPFv3
                    type: int
              connected:
                description: Specify connected routes
                type: dict
                suboptions:
                  set:
                    description: Set connected route
                    type: bool
                  metric:
                    description: Specify metric for redistributed routes
                    type: int
                  metric_type:
                    description: Specify OSPFv3 exterior metric type for redistributed routes
                    type: int
                  route_policy:
                    description: Apply route policy to redistribution
                    type: str
                  tag:
                    description: Set tag for routes redistributed into OSPFv3
                    type: int
              eigrp:
                description: Specify eigrp routes
                type: list
                elements: dict
                suboptions:
                  id:
                    description: EIGRP  process name
                    type: int
                    required: true
                  set:
                    description: Set bgp route number
                    type: bool
                  match:
                    description: Redistribution of EIGRP routes
                    type: str
                    choices: ["external", "internal"]
                  metric:
                    description: Specify metric for redistributed routes
                    type: int
                  metric_type:
                    description: Specify OSPFv3 exterior metric type for redistributed routes
                    type: int
                  route_policy:
                    description: Apply route policy to redistribution
                    type: str
                  tag:
                    description: Set tag for routes redistributed into OSPFv3
                    type: int
              isis:
                description: Specify IS-IS routes
                type: list
                elements: dict
                suboptions:
                  id:
                    description: IS-IS name
                    type: str
                    required: true
                  set:
                    description: Set IS-IS route number
                    type: bool
                  level:
                    description: Specify IS-IS level routes
                    type: str
                    choices: ["level-1", "level-1-2", "level-2"]
                  metric:
                    description: Specify metric for redistributed routes
                    type: int
                  metric_type:
                    description: Specify OSPFv3 exterior metric type for redistributed routes
                    type: int
                  route_policy:
                    description: Apply route policy to redistribution
                    type: str
                  tag:
                    description: Set tag for routes redistributed into OSPFv3
                    type: int
              mobile:
                description: Specify mobile routes
                type: dict
                suboptions:
                  set:
                    description: Set mobile route number
                    type: bool
                  metric:
                    description: Specify metric for redistributed routes
                    type: int
                  metric_type:
                    description: Specify OSPFv3 exterior metric type for redistributed routes
                    type: int
                  route_policy:
                    description: Apply route policy to redistribution
                    type: str
                  tag:
                    description: Set tag for routes redistributed into OSPFv3
                    type: int
              ospfv3:
                description: Specify ospfv3 routes
                type: list
                elements: dict
                suboptions:
                  id:
                    description: OSPFv3 process name
                    type: str
                    required: true
                  set:
                    description: Set ospfv3 route number
                    type: bool
                  match:
                    description: Redistribution of OSPFv3 routes
                    type: dict
                    suboptions:
                      external:
                        description: Redistribute OSPFv3 external routes
                        type: int
                        choices: ["1", "2"]
                      nssa_external:
                        description: Redistribute NSSA OSPFv3 external routes
                        type: int
                        choices: ["1", "2"]
                      internal:
                        description: Redistribute OSPFv3 internal routes
                        type: bool
                  metric:
                    description: Specify metric for redistributed routes
                    type: int
                  metric_type:
                    description: Specify OSPFv3 exterior metric type for redistributed routes
                    type: int
                  route_policy:
                    description: Apply route policy to redistribution
                    type: str
                  tag:
                    description: Set tag for routes redistributed into OSPFv3
                    type: int
              static:
                description: Specify static routes
                type: dict
                suboptions:
                  set:
                    description: Set static route
                    type: bool
                  metric:
                    description: Specify metric for redistributed routes
                    type: int
                  metric_type:
                    description: Specify OSPFv3 exterior metric type for redistributed routes
                    type: int
                  route_policy:
                    description: Apply route policy to redistribution
                    type: str
                  tag:
                    description: Set tag for routes redistributed into OSPFv3
                    type: int
              subscriber:
                description: Specify subscriber routes
                type: dict
                suboptions:
                  set:
                    description: Set static route
                    type: bool
                  metric:
                    description: Specify metric for redistributed routes
                    type: int
                  metric_type:
                    description: Specify OSPFv3 exterior metric type for redistributed routes
                    type: int
                  route_policy:
                    description: Apply route policy to redistribution
                    type: str
                  tag:
                    description: Set tag for routes redistributed into OSPFv3
                    type: int
          retransmit_interval:
            description: Delay between LSA retransmissions
            type: int
          router_id:
            description: ospfv3 router-id in IPv4 address format (A.B.C.D)
            type: str
          spf_prefix_priority:
            description: Specify SPF configuration
            type: dict
            suboptions:
              disable:
                description: Disable SPF prefix priority
                type: bool
              route_policy:
                description: Specify the route-policy to prioritize route install
                type: list
                elements: dict
                suboptions:
                  name:
                    description: Specify name of the policy
                    type: str
                  value:
                    description: Specify parameter values for the policy ()
                    type: str
          stub_router:
            description: Enter stub router configuration submode
            type: dict
            suboptions:
              router_lsa:
                description: Modify self originated router LSAs
                type: dict
                suboptions:
                  advertise_with:
                    description: Advertise LSAs with specified type
                    type: str
                    choices: ["max-metric", "r-bit", "v6-bit"]
                  always:
                    description: Force ospfv3 stub router mode unconditionally
                    type: bool
                  external_lsa:
                    description: Override External LSA metric in stub router mode
                    type: dict
                    suboptions:
                      set:
                        description: Set external lsa
                        type: bool
                      metric:
                        description: Metric to use while in stub router mode
                        type: int
                  include_stub:
                    description: Set maximum metric for stub links in stub router mode
                    type: bool
                  on_proc_migration:
                    description: Enter stub router mode on ospfv3 process migration
                    type: int
                  on_proc_restart:
                    description: Enter stub router mode on ospfv3 process restart
                    type: int
                  on_startup:
                    description: Enter stub router mode on startup
                    type: dict
                    suboptions:
                      time:
                        description: Time in seconds to stay in stub router mode
                        type: int
                      wait_for_bgp:
                        description: Exit stub router mode when BGP converges
                        type: bool
                  on_switchover:
                    description: Enter stub router mode on RP switchover
                    type: int
                  summary_lsa:
                    description: Override Summary LSA metric in stub router mode
                    type: dict
                    suboptions:
                      set:
                        description: Enable summary LSA
                        type: bool
                      metric:
                        description: Metric to use while in stub router mode
                        type: int
          summary_prefix:
            description: Configure IP address summaries
            type: list
            elements: dict
            suboptions:
              prefix:
                description: IP summary address/mask (A.B.C.D/prefix)
                type: str
                required: True
              not_advertise:
                description: Suppress routes that match the specified prefix/mask pair
                type: bool
              tag:
                description: Set tag
                type: int
          timers:
            description: Adjust routing timers
            type: dict
            suboptions:
              lsa_arrival:
                description: Specify LSA arrival timers
                type: int
              pacing:
                description: Specify pacing timers
                type: dict
                suboptions:
                  flood:
                    description: Flood pacing timer
                    type: int
                  lsa_group:
                    description: LSA group pacing timer
                    type: int
                  retransmission:
                    description: LSA group pacing timer
                    type: int
              throttle:
                description: Adjust throttle timers
                type: dict
                suboptions:
                  lsa:
                    description: Specify LSA throttle timers
                    type: dict
                    suboptions:
                      all_lsa_initial:
                        description: Delay to generate first occurrence of LSA in milliseconds
                        type: int
                      all_lsa_minimum:
                        description: Minimum delay between originating the same LSA in milliseconds
                        type: int
                  spf:
                    description: Specify SPF throttle timers
                    type: dict
                    suboptions:
                      spf_initial:
                        description: Delay to generate first occurrence of SPF in ms
                        type: int
                      spf_minimum:
                        description: Minimum delay between originating the same SPF in ms
                        type: int
          trace:
            description: Specify OSPF tracing options
            type: dict
            suboptions:
              size:
                description: Delete existing buffer and create one with N entries
                type: str
              value:
                description: Specify trace entry
                type: int
          transmit_delay:
            description: Estimated time needed to send link-state update packet
            type: int
  state:
    description:
      - The state the configuration should be left in
    type: str
    choices:
      - merged
      - replaced
      - overridden
      - deleted
      - gathered
      - rendered
      - parsed
    default: merged
"""
EXAMPLES = """
# Using merged

# Before state:
# -------------
#
# RP/0/RP0/CPU0:anton#show running-config router ospfv3
# Thu Jun 11 15:54:44.569 UTC
# % No such configuration item(s)
#

- name: Merge provided OSPFv3 configuration with the existing configuration
  cisco.iosxr.iosxr_ospfv3:
    config:
      processes:
        - process_id: 27
          areas:
            - area_id: 10
              hello_interval: 2
        - process_id: 26
          authentication:
            disable: true
        - process_id: 10
          areas:
            - area_id: 11
              default_cost: 5
              cost: 11
            - area_id: 22
              default_cost: 6
        - process_id: 30
          areas:
            - area_id: 11
              default_cost: 5
            - area_id: 22
              default_cost: 6
          cost: 2
          default_metric: 10
          transmit_delay: 2
          hello_interval: 1
          dead_interval: 2
          retransmit_interval: 2
          packet_size: 577
          priority: 1
          router_id: '2.2.2.2'
          demand_circuit: true
          mtu_ignore: true
    state: merged

#
# Task Output:
# ------------
#
# before: {}
#
# - router ospfv3 10
#   - area 11 default-cost 5
#   - area 11 cost 11
#   - area 22 default-cost 6
#   - router ospfv3 26
#   - authentication disable
#   - router ospfv3 27
#   - area 10 hello-interval 2
#   - router ospfv3 30
#   - cost 2
#   - priority 1
#   - default-metric 10
#   - router-id 2.2.2.2
#   - demand-circuit
#   - packet-size 577
#   - transmit-delay 2
#   - dead-interval 2
#   - hello-interval 1
#   - retransmit-interval 2
#   - mtu-ignore
#   - area 11 default-cost 5
#   - area 22 default-cost 6
#
# after:
#     processes:
#     - areas:
#       - area_id: '11'
#         cost: 11
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       process_id: '10'
#     - authentication:
#         disable: true
#       process_id: '26'
#     - areas:
#       - area_id: '10'
#         hello_interval: 2
#       process_id: '27'
#     - areas:
#       - area_id: '11'
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       cost: 2
#       dead_interval: 2
#       default_metric: 10
#       demand_circuit: true
#       hello_interval: 1
#       mtu_ignore: true
#       packet_size: 577
#       priority: 1
#       process_id: '30'
#       retransmit_interval: 2
#       router_id: 2.2.2.2
#       transmit_delay: 2
#
# After state:
# ------------
#
# RP/0/RP0/CPU0:anton#show running-config router ospfv3
# router ospfv3 10
#  area 11
#   cost 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !
# router ospfv3 26
#  authentication disable
# !
# router ospfv3 27
#  area 10
#   hello-interval 2
#  !
# !
# router ospfv3 30
#  cost 2
#  priority 1
#  mtu-ignore
#  packet-size 577
#  dead-interval 2
#  retransmit-interval 2
#  demand-circuit
#  hello-interval 1
#  transmit-delay 2
#  router-id 2.2.2.2
#  default-metric 10
#  area 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !

# Using replaced
#
# Before state:
# -------------
#
#
# RP/0/RP0/CPU0:anton#show running-config router ospf
# router ospfv3 10
#  area 11
#   cost 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !
# router ospfv3 26
#  authentication disable
# !
# router ospfv3 27
#  area 10
#   hello-interval 2
#  !
# !
# router ospfv3 30
#  cost 2
#  priority 1
#  mtu-ignore
#  packet-size 577
#  dead-interval 2
#  retransmit-interval 2
#  demand-circuit
#  hello-interval 1
#  transmit-delay 2
#  router-id 2.2.2.2
#  default-metric 10
#  area 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !

- name: Replace OSPFv3 routes configurations from the device
  cisco.iosxr.iosxr_ospfv3:
    config:
      processes:
        - process_id: 27
          areas:
            - area_id: 10
              hello_interval: 2
            - area_id: 20
              cost: 2
              default_cost: 2
        - process_id: 26
          authentication:
            disable: true
    state: replaced

#
# Task Output:
# ------------
#
# before:
#     processes:
#     - areas:
#       - area_id: '11'
#         cost: 11
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       process_id: '10'
#     - authentication:
#         disable: true
#       process_id: '26'
#     - areas:
#       - area_id: '10'
#         hello_interval: 2
#       process_id: '27'
#     - areas:
#       - area_id: '11'
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       cost: 2
#       dead_interval: 2
#       default_metric: 10
#       demand_circuit: true
#       hello_interval: 1
#       mtu_ignore: true
#       packet_size: 577
#       priority: 1
#       process_id: '30'
#       retransmit_interval: 2
#       router_id: 2.2.2.2
#       transmit_delay: 2
#
# commands:
#   - router ospfv3 27
#   - area 20 default-cost 2
#   - area 20 cost 2
#
# after:
#     processes:
#     - areas:
#       - area_id: '11'
#         cost: 11
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       process_id: '10'
#     - authentication:
#         disable: true
#       process_id: '26'
#     - areas:
#       - area_id: '10'
#         hello_interval: 2
#       - area_id: '20'
#         cost: 2
#         default_cost: 2
#       process_id: '27'
#     - areas:
#       - area_id: '11'
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       cost: 2
#       dead_interval: 2
#       default_metric: 10
#       demand_circuit: true
#       hello_interval: 1
#       mtu_ignore: true
#       packet_size: 577
#       priority: 1
#       process_id: '30'
#       retransmit_interval: 2
#       router_id: 2.2.2.2
#       transmit_delay: 2
#
#
# After state:
# ------------
#
# RP/0/RP0/CPU0:anton(config)#do show running-config router ospfv3
# router ospfv3 10
#  area 11
#   cost 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !
# router ospfv3 26
#  authentication disable
# !
# router ospfv3 27
#  area 10
#   hello-interval 2
#  !
#  area 20
#   cost 2
#   default-cost 2
#  !
# !
# router ospfv3 30
#  cost 2
#  priority 1
#  mtu-ignore
#  packet-size 577
#  dead-interval 2
#  retransmit-interval 2
#  demand-circuit
#  hello-interval 1
#  transmit-delay 2
#  router-id 2.2.2.2
#  default-metric 10
#  area 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !

# Using overridden
#
# Before state:
# -------------
#
# router ospfv3 10
#  area 11
#   cost 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !
# router ospfv3 26
#  authentication disable
# !
# router ospfv3 27
#  area 10
#   hello-interval 2
#  !
#  area 20
#   cost 2
#   default-cost 2
#  !
# !
# router ospfv3 30
#  cost 2
#  priority 1
#  mtu-ignore
#  packet-size 577
#  dead-interval 2
#  retransmit-interval 2
#  demand-circuit
#  hello-interval 1
#  transmit-delay 2
#  router-id 2.2.2.2
#  default-metric 10
#  area 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !

- name: Override existing OSPFv3 configurations from the device
  cisco.iosxr.iosxr_ospfv3:
    config:
      processes:
        - process_id: 27
          areas:
            - area_id: 10
              hello_interval: 2
              authentication:
                disable: true
            - area_id: 20
              cost: 2
              default_cost: 2
              authentication:
                disable: true
        - process_id: 26
          areas:
            - area_id: 10
              hello_interval: 2
              authentication:
                disable: true
    state: overridden

#
# Task Output:
# ------------
#
# before:
#     processes:
#     - areas:
#       - area_id: '11'
#         cost: 11
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       process_id: '10'
#     - authentication:
#         disable: true
#       process_id: '26'
#     - areas:
#       - area_id: '10'
#         hello_interval: 2
#       - area_id: '20'
#         cost: 2
#         default_cost: 2
#       process_id: '27'
#     - areas:
#       - area_id: '11'
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       cost: 2
#       dead_interval: 2
#       default_metric: 10
#       demand_circuit: true
#       hello_interval: 1
#       mtu_ignore: true
#       packet_size: 577
#       priority: 1
#       process_id: '30'
#       retransmit_interval: 2
#       router_id: 2.2.2.2
#       transmit_delay: 2
#
# commands:
#   - router ospfv3 10
#   - no area 11 default-cost 5
#   - no area 11 cost 11
#   - no area 22 default-cost 6
#   - router ospfv3 30
#   - no cost 2
#   - no priority 1
#   - no default-metric 10
#   - no router-id 2.2.2.2
#   - no demand-circuit
#   - no packet-size 577
#   - no transmit-delay 2
#   - no dead-interval 2
#   - no hello-interval 1
#   - no retransmit-interval 2
#   - no mtu-ignore
#   - no area 11 default-cost 5
#   - no area 22 default-cost 6
#   - router ospfv3 27
#   - area 10 authentication disable
#   - area 20 authentication disable
#   - router ospfv3 26
#   - no authentication disable
#   - area 10 authentication disable
#   - area 10 hello-interval 2
#
# after:
#     processes:
#     - process_id: '10'
#     - areas:
#       - area_id: '10'
#         authentication:
#           disable: true
#         hello_interval: 2
#       process_id: '26'
#     - areas:
#       - area_id: '10'
#         authentication:
#           disable: true
#         hello_interval: 2
#       - area_id: '20'
#         authentication:
#           disable: true
#         cost: 2
#         default_cost: 2
#       process_id: '27'
#     - process_id: '30'
#
# After state:
# ------------
#
# RP/0/RP0/CPU0:anton#show running-config router ospfv3
# router ospfv3 10
#  area 11
#  !
#  area 22
#  !
# !
# router ospfv3 26
#  area 10
#   authentication disable
#   hello-interval 2
#  !
# !
# router ospfv3 27
#  area 10
#   authentication disable
#   hello-interval 2
#  !
#  area 20
#   cost 2
#   authentication disable
#   default-cost 2
#  !
# !
# router ospfv3 30
#  area 11
#  !
#  area 22
#  !
# !

# Using deleted
#
# Before state:
# -------------
#
#
# RP/0/RP0/CPU0:anton#show running-config router ospfv3
# router ospfv3 10
#  area 11
#   cost 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !
# router ospfv3 26
#  authentication disable
#  area 10
#   authentication disable
#   hello-interval 2
#  !
# !
# router ospfv3 27
#  area 10
#   authentication disable
#   hello-interval 2
#  !
#  area 20
#   cost 2
#   authentication disable
#   default-cost 2
#  !
# !
# router ospfv3 30
#  cost 2
#  priority 1
#  mtu-ignore
#  packet-size 577
#  dead-interval 2
#  retransmit-interval 2
#  demand-circuit
#  hello-interval 1
#  transmit-delay 2
#  router-id 2.2.2.2
#  default-metric 10
#  area 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !

- name: Deleted existing OSPFv3 configurations from the device
  cisco.iosxr.iosxr_ospfv3:
    config:
      processes:
      - process_id: '10'
      - process_id: '26'
      - process_id: '27'
      - process_id: '30'
    state: deleted

#
# Task Output:
# ------------
#
# before:
#     processes:
#     - areas:
#       - area_id: '11'
#         cost: 11
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       process_id: '10'
#     - areas:
#       - area_id: '10'
#         authentication:
#           disable: true
#         hello_interval: 2
#       authentication:
#         disable: true
#       process_id: '26'
#     - areas:
#       - area_id: '10'
#         authentication:
#           disable: true
#         hello_interval: 2
#       - area_id: '20'
#         authentication:
#           disable: true
#         cost: 2
#         default_cost: 2
#       process_id: '27'
#     - areas:
#       - area_id: '11'
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       cost: 2
#       dead_interval: 2
#       default_metric: 10
#       demand_circuit: true
#       hello_interval: 1
#       mtu_ignore: true
#       packet_size: 577
#       priority: 1
#       process_id: '30'
#       retransmit_interval: 2
#       router_id: 2.2.2.2
#       transmit_delay: 2
#
# commands:
#   - router ospfv3 10
#   - no area 11 default-cost 5
#   - no area 11 cost 11
#   - no area 22 default-cost 6
#   - router ospfv3 26
#   - no authentication disable
#   - no area 10 authentication disable
#   - no area 10 hello-interval 2
#   - router ospfv3 27
#   - no area 10 authentication disable
#   - no area 10 hello-interval 2
#   - no area 20 authentication disable
#   - no area 20 default-cost 2
#   - no area 20 cost 2
#   - router ospfv3 30
#   - no cost 2
#   - no priority 1
#   - no default-metric 10
#   - no router-id 2.2.2.2
#   - no demand-circuit
#   - no packet-size 577
#   - no transmit-delay 2
#   - no dead-interval 2
#   - no hello-interval 1
#   - no retransmit-interval 2
#   - no mtu-ignore
#   - no area 11 default-cost 5
#   - no area 22 default-cost 6
#
# after:
#     processes:
#     - process_id: '10'
#     - process_id: '26'
#     - process_id: '27'
#     - process_id: '30'
#
# After state:
# ------------
#
# RP/0/RP0/CPU0:anton(config)#show running-config router ospfv3
# router ospfv3 10
#  area 11
#  !
#  area 22
#  !
# !
# router ospfv3 26
#  area 10
#  !
# !
# router ospfv3 27
#  area 10
#  !
#  area 20
#  !
# !
# router ospfv3 30
#  area 11
#  !
#  area 22
#  !
# !

# Using deleted
#
# Before state:
# -------------
#
#
# RP/0/RP0/CPU0:anton#show running-config router ospfv3
# router ospfv3 10
#  area 11
#   cost 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !
# router ospfv3 26
#  authentication disable
#  area 10
#   authentication disable
#   hello-interval 2
#  !
# !
# router ospfv3 27
#  area 10
#   authentication disable
#   hello-interval 2
#  !
#  area 20
#   cost 2
#   authentication disable
#   default-cost 2
#  !
# !
# router ospfv3 30
#  cost 2
#  priority 1
#  mtu-ignore
#  packet-size 577
#  dead-interval 2
#  retransmit-interval 2
#  demand-circuit
#  hello-interval 1
#  transmit-delay 2
#  router-id 2.2.2.2
#  default-metric 10
#  area 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !

- name: Deleted existing OSPFv3 configurations from the device
  cisco.iosxr.iosxr_ospfv3:
    config:
    state: deleted

#
# Task Output:
# ------------
#
# before:
#     processes:
#     - areas:
#       - area_id: '11'
#         cost: 11
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       process_id: '10'
#     - areas:
#       - area_id: '10'
#         authentication:
#           disable: true
#         hello_interval: 2
#       authentication:
#         disable: true
#       process_id: '26'
#     - areas:
#       - area_id: '10'
#         authentication:
#           disable: true
#         hello_interval: 2
#       - area_id: '20'
#         authentication:
#           disable: true
#         cost: 2
#         default_cost: 2
#       process_id: '27'
#     - areas:
#       - area_id: '11'
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       cost: 2
#       dead_interval: 2
#       default_metric: 10
#       demand_circuit: true
#       hello_interval: 1
#       mtu_ignore: true
#       packet_size: 577
#       priority: 1
#       process_id: '30'
#       retransmit_interval: 2
#       router_id: 2.2.2.2
#       transmit_delay: 2
#
# commands:
#   - router ospfv3 10
#   - no area 11 default-cost 5
#   - no area 11 cost 11
#   - no area 22 default-cost 6
#   - router ospfv3 26
#   - no authentication disable
#   - no area 10 authentication disable
#   - no area 10 hello-interval 2
#   - router ospfv3 27
#   - no area 10 authentication disable
#   - no area 10 hello-interval 2
#   - no area 20 authentication disable
#   - no area 20 default-cost 2
#   - no area 20 cost 2
#   - router ospfv3 30
#   - no cost 2
#   - no priority 1
#   - no default-metric 10
#   - no router-id 2.2.2.2
#   - no demand-circuit
#   - no packet-size 577
#   - no transmit-delay 2
#   - no dead-interval 2
#   - no hello-interval 1
#   - no retransmit-interval 2
#   - no mtu-ignore
#   - no area 11 default-cost 5
#   - no area 22 default-cost 6
#
# after:
#     processes:
#     - process_id: '10'
#     - process_id: '26'
#     - process_id: '27'
#     - process_id: '30'
#
# After state:
# ------------
#
# RP/0/RP0/CPU0:anton(config)#show running-config router ospfv3
# router ospfv3 10
#  area 11
#  !
#  area 22
#  !
# !
# router ospfv3 26
#  area 10
#  !
# !
# router ospfv3 27
#  area 10
#  !
#  area 20
#  !
# !
# router ospfv3 30
#  area 11
#  !
#  area 22
#  !
# !


# Using parsed
#
# parsed.cfg
# ------------
# router ospfv3 10
#  area 11
#   cost 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !
# router ospfv3 26
#  authentication disable
# !
# router ospfv3 27
#  area 10
#   hello-interval 2
#  !
# !
# router ospfv3 30
#  router-id 2.2.2.2
#  cost 2
#  packet-size 577
#  priority 1
#  mtu-ignore
#  dead-interval 2
#  retransmit-interval 2
#  demand-circuit
#  hello-interval 1
#  transmit-delay 2
#  default-metric 10
#  area 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !
- name: Parsed the device configuration to get output commands
  cisco.iosxr.iosxr_ospfv3:
    running_config: "{{ lookup('file', './parsed.cfg') }}"
    state: parsed
#
#
# Task Output:
# ------------
#
# parsed:
#     processes:
#     - areas:
#       - area_id: '11'
#         cost: 11
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       process_id: '10'
#     - authentication:
#         disable: true
#       process_id: '26'
#     - areas:
#       - area_id: '10'
#         hello_interval: 2
#       process_id: '27'
#     - areas:
#       - area_id: '11'
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       cost: 2
#       dead_interval: 2
#       default_metric: 10
#       demand_circuit: true
#       hello_interval: 1
#       mtu_ignore: true
#       packet_size: 577
#       priority: 1
#       process_id: '30'
#       retransmit_interval: 2
#       router_id: 2.2.2.2
#       transmit_delay: 2
#
# Using rendered
#
- name: Render the commands for provided  configuration
  cisco.iosxr.iosxr_ospfv3:
    config:
      processes:
        - process_id: 27
          areas:
            - area_id: 10
              hello_interval: 2
        - process_id: 26
          authentication:
            disable: true
        - process_id: 10
          areas:
            - area_id: 11
              default_cost: 5
              cost: 11
            - area_id: 22
              default_cost: 6
        - process_id: 30
          areas:
            - area_id: 11
              default_cost: 5
            - area_id: 22
              default_cost: 6
          cost: 2
          default_metric: 10
          transmit_delay: 2
          hello_interval: 1
          dead_interval: 2
          retransmit_interval: 2
          packet_size: 577
          priority: 1
          router_id: '2.2.2.2'
          demand_circuit: true
          mtu_ignore: true
    state: rendered

#
#
# Task Output:
# ------------
#
# rendered:
#   - router ospfv3 27
#   - area 10 hello-interval 2
#   - router ospfv3 26
#   - authentication disable
#   - router ospfv3 10
#   - area 11 default-cost 5
#   - area 11 cost 11
#   - area 22 default-cost 6
#   - router ospfv3 30
#   - cost 2
#   - priority 1
#   - default-metric 10
#   - router-id 2.2.2.2
#   - demand-circuit
#   - packet-size 577
#   - transmit-delay 2
#   - dead-interval 2
#   - hello-interval 1
#   - retransmit-interval 2
#   - mtu-ignore
#   - area 11 default-cost 5
#   - area 22 default-cost 6


# Using gathered
#
# Before state:
# -------------
#
# RP/0/RP0/CPU0:anton#show running-config router ospfv3
# router ospfv3 10
#  area 11
#   cost 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !
# router ospfv3 26
#  authentication disable
#  area 10
#  !
# !
# router ospfv3 27
#  area 10
#   hello-interval 2
#  !
#  area 20
#  !
# !
# router ospfv3 30
#  cost 2
#  priority 1
#  mtu-ignore
#  packet-size 577
#  dead-interval 2
#  retransmit-interval 2
#  demand-circuit
#  hello-interval 1
#  transmit-delay 2
#  router-id 2.2.2.2
#  default-metric 10
#  area 11
#   default-cost 5
#  !
#  area 22
#   default-cost 6
#  !
# !

- name: Gather ospfv3 routes configuration
  cisco.iosxr.iosxr_ospfv3:
    state: gathered
#
#
# Task Output:
# ------------
#
# gathered:
#     processes:
#     - areas:
#       - area_id: '11'
#         cost: 11
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       process_id: '10'
#     - authentication:
#         disable: true
#       process_id: '26'
#     - areas:
#       - area_id: '10'
#         hello_interval: 2
#       process_id: '27'
#     - areas:
#       - area_id: '11'
#         default_cost: 5
#       - area_id: '22'
#         default_cost: 6
#       cost: 2
#       dead_interval: 2
#       default_metric: 10
#       demand_circuit: true
#       hello_interval: 1
#       mtu_ignore: true
#       packet_size: 577
#       priority: 1
#       process_id: '30'
#       retransmit_interval: 2
#       router_id: 2.2.2.2
#       transmit_delay: 2
#
"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample:
  - router ospfv3 10
  - area 11 default-cost 5
  - area 11 cost 11
  - area 22 default-cost 6

rendered:
  description: The provided configuration in the task rendered in device-native format (offline).
  returned: when I(state) is C(rendered)
  type: list
  sample:
  - router ospfv3 27
  - area 10 hello-interval 2
gathered:
  description: Facts about the network resource gathered from the remote device as structured data.
  returned: when I(state) is C(gathered)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
parsed:
  description: The device native config provided in I(running_config) option parsed into structured data as per module argspec.
  returned: when I(state) is C(parsed)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
"""

from ansible.module_utils.basic import AnsibleModule

from ansible_collections.cisco.iosxr.plugins.module_utils.network.iosxr.argspec.ospfv3.ospfv3 import (
    Ospfv3Args,
)
from ansible_collections.cisco.iosxr.plugins.module_utils.network.iosxr.config.ospfv3.ospfv3 import (
    Ospfv3,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    module = AnsibleModule(
        argument_spec=Ospfv3Args.argument_spec,
        mutually_exclusive=[["config", "running_config"]],
        required_if=[
            ["state", "merged", ["config"]],
            ["state", "replaced", ["config"]],
            ["state", "overridden", ["config"]],
            ["state", "rendered", ["config"]],
            ["state", "parsed", ["running_config"]],
        ],
        supports_check_mode=True,
    )

    result = Ospfv3(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
