# -*- coding: utf-8 -*-
# Copyright 2025 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the ios_interfaces module
"""


class InterfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_interfaces module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "description": {"type": "str"},
                "enabled": {"type": "bool", "default": True},
                "speed": {"type": "str"},
                "mtu": {"type": "int"},
                "mode": {"choices": ["layer2", "layer3"], "type": "str"},
                "duplex": {"type": "str", "choices": ["full", "half", "auto"]},
                "template": {"type": "str"},
                "mac_address": {"type": "str"},
                "service_policy": {
                    "type": "dict",
                    "options": {
                        "input": {"type": "str"},
                        "output": {"type": "str"},
                        "type_options": {
                            "type": "dict",
                            "options": {
                                "access_control": {
                                    "type": "dict",
                                    "options": {
                                        "input": {"type": "str"},
                                        "output": {"type": "str"},
                                    },
                                },
                                "epbr": {
                                    "type": "dict",
                                    "options": {
                                        "input": {"type": "str"},
                                        "output": {"type": "str"},
                                    },
                                },
                                "nwpi": {
                                    "type": "dict",
                                    "options": {
                                        "input": {"type": "str"},
                                        "output": {"type": "str"},
                                    },
                                },
                                "packet_service": {
                                    "type": "dict",
                                    "options": {
                                        "input": {"type": "str"},
                                        "output": {"type": "str"},
                                    },
                                },
                                "service_chain": {
                                    "type": "dict",
                                    "options": {
                                        "input": {"type": "str"},
                                        "output": {"type": "str"},
                                    },
                                },
                            },
                        },
                    },
                },
                "logging": {
                    "type": "dict",
                    "options": {
                        "bundle_status": {"type": "bool"},
                        "link_status": {"type": "bool"},
                        "nfas_status": {"type": "bool"},
                        "spanning_tree": {"type": "bool"},
                        "status": {"type": "bool"},
                        "subif_link_status": {"type": "bool"},
                        "trunk_status": {"type": "bool"},
                    },
                },
                "snmp": {
                    "type": "dict",
                    "options": {
                        "trap": {
                            "type": "dict",
                            "options": {
                                "ip": {"type": "bool"},
                                "link_status": {"type": "bool"},
                                "mac_notification_added": {"type": "bool"},
                                "mac_notification_removed": {"type": "bool"},
                            },
                        },
                        "ifindex": {
                            "type": "dict",
                            "options": {
                                "clear": {"type": "bool"},
                                "persist": {"type": "bool"},
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "rendered",
                "gathered",
                "purged",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
