# (c) 2016, Charles Paul <cpaul@ansible.com>
#
# This file is part of Ansible
#
# Ansible is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Ansible is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <http://www.gnu.org/licenses/>.


class ModuleDocFragment(object):
    # Parameters for VMware modules
    DOCUMENTATION = '''
options:
    hostname:
        description:
            - The hostname or IP address of the vSphere vCenter.
        required: True
    username:
        description:
            - The username of the vSphere vCenter.
        required: True
        aliases: ['user', 'admin']
    password:
        description:
            - The password of the vSphere vCenter.
        required: True
        aliases: ['pass', 'pwd']
    validate_certs:
        description:
            - Allows connection when SSL certificates are not valid. Set to
              false when certificates are not trusted.
        required: False
        default: 'True'
        choices: ['True', 'False']
    port:
        description:
            - The port number of the vSphere vCenter or ESXi server.
        required: False
        default: 443
        version_added: 2.5
'''
