# Generated by Django 4.1.8 on 2023-05-07 06:52

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('dcim', '0167_module_status'),
        ('extras', '0084_staging'),
    ]

    operations = [
        migrations.CreateModel(
            name='LDP',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
                ),
                ('auto_range', models.BooleanField(default=True)),
                (
                    'label_start',
                    models.PositiveIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(1048575),
                        ],
                    ),
                ),
                (
                    'label_end',
                    models.PositiveIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(1048575),
                        ],
                    ),
                ),
                ('comments', models.TextField()),
                ('device', models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, to='dcim.device')),
                (
                    'ldp_enabled_interfaces',
                    models.ManyToManyField(
                        limit_choices_to=models.Q(('device_id', models.F('device'))), to='dcim.interface'
                    ),
                ),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'LDP Participant',
                'verbose_name_plural': 'LDP Participants',
            },
        ),
        migrations.CreateModel(
            name='BGP_CE',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
                ),
                ('name', models.CharField(max_length=50)),
                ('comments', models.TextField()),
                ('asn', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='ipam.asn')),
                ('ip_addresses', models.ManyToManyField(to='ipam.ipaddress')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'BGP Customer Edge',
                'verbose_name_plural': 'BGP Customer Edges',
            },
        ),
        migrations.CreateModel(
            name='BGP_PE',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
                ),
                ('comments', models.TextField()),
                ('advertised_customers', models.ManyToManyField(blank=True, to='argos.bgp_ce')),
                ('asn', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='ipam.asn')),
                ('device', models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, to='dcim.device')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                (
                    'update_source_interface',
                    models.OneToOneField(
                        limit_choices_to=models.Q(('device_id', models.F('device'))),
                        on_delete=django.db.models.deletion.PROTECT,
                        to='dcim.interface',
                    ),
                ),
            ],
            options={
                'verbose_name': 'BGP Provider Edge',
                'verbose_name_plural': 'BGP Provider Edges',
            },
        ),
        migrations.CreateModel(
            name='Address_Family',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
                ),
                ('comments', models.TextField()),
                ('vpnv4_address_family', models.BooleanField(default=True)),
                ('vpnv4_community', models.CharField(max_length=50, null=True, blank=True)),
                ('vpnv6_address_family', models.BooleanField(default=True)),
                ('vpnv6_community', models.CharField(max_length=50, null=True, blank=True)),
                ('name', models.CharField(max_length=50)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'Address Family',
                'verbose_name_plural': 'Address Families',
            },
        ),
        migrations.CreateModel(
            name='BGP_Mesh',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
                ),
                ('comments', models.TextField()),
                ('bgp_mesh', models.ManyToManyField(blank=False, related_name='bgp_mesh', to='argos.bgp_pe')),
                (
                    'address_family',
                    models.ForeignKey(
                        blank=False, on_delete=django.db.models.deletion.PROTECT, to='argos.address_family'
                    ),
                ),
                ('name', models.CharField(max_length=50)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'BGP Mesh',
                'verbose_name_plural': 'BGP Meshes',
            },
        ),
        migrations.CreateModel(
            name='MPLS_Instance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
                ),
                ('service', models.CharField(blank=False, max_length=50, null=False)),
                ('name', models.CharField(max_length=50)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('comments', models.TextField()),
                (
                    'ibgp',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT, related_name='ibgp', to='argos.bgp_mesh'
                    ),
                ),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'MPLS Instance',
                'verbose_name_plural': 'MPLS Instances',
            },
        ),
    ]
