/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.selector.DeterministicSelector;
import org.apache.commons.configuration.Configuration;

public class BettersSelector
extends DeterministicSelector {
    private static final long serialVersionUID = -697152908546090334L;
    protected transient Comparator<IIndividual> individualsComparator = new Comparator<IIndividual>(){

        @Override
        public int compare(IIndividual arg0, IIndividual arg1) {
            return BettersSelector.this.fitnessComparator.compare(arg0.getFitness(), arg1.getFitness());
        }
    };
    protected transient Comparator<IFitness> fitnessComparator;
    protected transient ArrayList<IIndividual> auxList = new ArrayList();

    public BettersSelector() {
    }

    public BettersSelector(ISystem context) {
        this.contextualize(context);
    }

    public final void configure(Configuration settings) {
    }

    public boolean equals(Object other) {
        return other instanceof BettersSelector;
    }

    @Override
    protected void prepareSelection() {
        this.auxList.clear();
        this.fitnessComparator = this.context.getEvaluator().getComparator();
        for (IIndividual ind : this.actsrc) {
            this.auxList.add(ind);
        }
    }

    @Override
    protected IIndividual selectNext() {
        if (this.auxList.isEmpty()) {
            this.prepareSelection();
        }
        IIndividual best = Collections.max(this.auxList, this.individualsComparator);
        this.auxList.remove(best);
        return best;
    }
}

