/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.MODENARProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.parseParameters;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class MODENAR {
    String outputTr;
    String outputTst;
    myDataset trans;
    String assoc_rules_fname;
    String sup_rules_fname;
    private String paretoFilename;
    private String fileTime;
    private String fileHora;
    private String namedataset;
    MODENARProcess ap;
    private ArrayList<AssociationRule> associationRulesPareto;
    int nEvaluations;
    int popSize;
    double CR;
    int threshold;
    int nObj;
    int AF;
    double[] Wk;
    long startTime;
    long totalTime;
    private boolean somethingWrong = false;

    public MODENAR() {
    }

    public MODENAR(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.trans = new myDataset();
        try {
            this.namedataset = parameters.getTransactionsInputFile();
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.trans.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.trans.hasMissingAttributes();
        this.assoc_rules_fname = parameters.getAssociationRulesFile();
        this.sup_rules_fname = parameters.getOutputFile(0);
        this.paretoFilename = parameters.getOutputFile(1);
        this.fileTime = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/hora.txt";
        long seed = Long.parseLong(parameters.getParameter(0));
        this.popSize = Integer.parseInt(parameters.getParameter(1));
        this.nEvaluations = Integer.parseInt(parameters.getParameter(2));
        this.CR = Double.parseDouble(parameters.getParameter(3));
        this.threshold = Integer.parseInt(parameters.getParameter(4));
        this.AF = Integer.parseInt(parameters.getParameter(5));
        this.Wk = new double[4];
        int i = 0;
        int posParameter = 5;
        while (i < 4) {
            this.Wk[i] = Double.parseDouble(parameters.getParameter(posParameter));
            ++i;
            ++posParameter;
        }
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, either the data-set have numerical values or missing values.");
            System.err.println("Aborting the program");
        } else {
            this.ap = new MODENARProcess(this.trans, this.nEvaluations, this.popSize, this.CR, this.threshold, this.Wk, this.AF);
            this.ap.run();
            this.associationRulesPareto = this.ap.getAssoc_rules_Pareto();
            try {
                PrintWriter rule_writer = new PrintWriter(this.assoc_rules_fname);
                PrintWriter sup_writer = new PrintWriter(this.sup_rules_fname);
                PrintWriter pareto_writer = new PrintWriter(this.paretoFilename);
                rule_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rule_writer.println("<association_rules>");
                sup_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                sup_writer.println("<values>");
                pareto_writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                pareto_writer.println("<values>");
                for (int i = 0; i < this.associationRulesPareto.size(); ++i) {
                    int j;
                    AssociationRule a_r = this.associationRulesPareto.get(i);
                    ArrayList<Gene> ant = a_r.getAntecedent();
                    ArrayList<Gene> cons = a_r.getConsequent();
                    rule_writer.println("<rule id=\"" + i + "\">");
                    sup_writer.println("<rule id=\"" + i + "\" rule_support=\"" + MODENARProcess.roundDouble(a_r.getAll_support(), 2) + "\" antecedent_support=\"" + MODENARProcess.roundDouble(a_r.getSupport(), 2) + "\" consequent_support=\"" + MODENARProcess.roundDouble(a_r.getSupport_consq(), 2) + "\" confidence=\"" + MODENARProcess.roundDouble(a_r.getConfidence(), 2) + "\" lift=\"" + MODENARProcess.roundDouble(a_r.getLift(), 2) + "\" conviction=\"" + MODENARProcess.roundDouble(a_r.getConv(), 2) + "\" certainFactor=\"" + MODENARProcess.roundDouble(a_r.getCF(), 2) + "\" netConf=\"" + MODENARProcess.roundDouble(a_r.getNetConf(), 2) + "\" yulesQ=\"" + MODENARProcess.roundDouble(a_r.getYulesQ(), 2) + "\" nAttributes=\"" + (a_r.getLengthAntecedent() + a_r.getLengthConsequent()) + "\"/>");
                    rule_writer.println("<antecedents>");
                    for (j = 0; j < ant.size(); ++j) {
                        Gene g_ant = ant.get(j);
                        this.createRule(g_ant, rule_writer);
                    }
                    rule_writer.println("</antecedents>");
                    rule_writer.println("<consequents>");
                    for (j = 0; j < cons.size(); ++j) {
                        Gene g_cons = cons.get(j);
                        this.createRule(g_cons, rule_writer);
                    }
                    rule_writer.println("</consequents>");
                    rule_writer.println("</rule>");
                }
                rule_writer.println("</association_rules>");
                sup_writer.println("</values>");
                rule_writer.close();
                sup_writer.close();
                pareto_writer.print(this.ap.getParetos());
                pareto_writer.println("</values>");
                pareto_writer.close();
                this.totalTime = System.currentTimeMillis() - this.startTime;
                this.writeTime();
                System.out.println("Algorithm Finished");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.namedataset + this.assoc_rules_fname + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.assoc_rules_fname + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void createRule(Gene g, PrintWriter w) {
        int attr = g.getAttr();
        w.print("<attribute name=\"" + Attributes.getAttribute(attr).getName() + "\" value=\"");
        if (g.getType() == 0) {
            w.print(Attributes.getAttribute(attr).getNominalValue((int)g.getL()));
        } else {
            w.print("[" + g.getL() + ", " + g.getU() + "]");
        }
        w.println("\" />");
    }
}

