/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD;

import java.io.IOException;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class myDataset {
    public static final int REAL = 0;
    public static final int INTEGER = 1;
    public static final int NOMINAL = 2;
    private double[][] X = null;
    private boolean[][] missing = null;
    private boolean[] nominal = null;
    private boolean[] integer = null;
    private int[] outputInteger = null;
    private double[] outputReal = null;
    private String[] output = null;
    private double[] emax;
    private double[] emin;
    private int nData;
    private int nVars;
    private int nInputs;
    private int nClasses;
    private InstanceSet IS = new InstanceSet();
    private double[] stdev;
    private double[] average;
    private int[] instancesCl;
    private double[] frecuentCl;

    public double[][] getX() {
        return this.X;
    }

    public double[] getExample(int pos) {
        return this.X[pos];
    }

    public int[] getOutputAsInteger() {
        int[] output = new int[this.outputInteger.length];
        for (int i = 0; i < this.outputInteger.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public double[] getOutputAsReal() {
        double[] output = new double[this.outputReal.length];
        for (int i = 0; i < this.outputReal.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public String[] getOutputAsString() {
        String[] output = new String[this.output.length];
        for (int i = 0; i < this.output.length; ++i) {
            output[i] = this.output[i];
        }
        return output;
    }

    public String getOutputAsString(int pos) {
        return this.output[pos];
    }

    public int getOutputAsInteger(int pos) {
        return this.outputInteger[pos];
    }

    public double getOutputAsReal(int pos) {
        return this.outputReal[pos];
    }

    public double[] getemax() {
        return this.emax;
    }

    public double[] getemin() {
        return this.emin;
    }

    public double getMax(int variable) {
        return this.emax[variable];
    }

    public double getMin(int variable) {
        return this.emin[variable];
    }

    public int getnData() {
        return this.nData;
    }

    public int getnVars() {
        return this.nVars;
    }

    public int getnInputs() {
        return this.nInputs;
    }

    public int getnClasses() {
        return this.nClasses;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public boolean isNominal(int i) {
        return this.nominal[i];
    }

    public boolean isInteger(int i) {
        return this.integer[i];
    }

    public void readClassificationSet(String datasetFile, boolean train) throws IOException {
        try {
            int i;
            this.IS.readSet(datasetFile, train);
            this.nData = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVars = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
                System.exit(1);
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
                System.exit(1);
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.nominal = new boolean[this.nInputs];
            this.integer = new boolean[this.nInputs];
            this.outputInteger = new int[this.nData];
            this.outputReal = new double[this.nData];
            this.output = new String[this.nData];
            this.emax = new double[this.nInputs];
            this.emin = new double[this.nInputs];
            for (i = 0; i < this.nInputs; ++i) {
                if (Attributes.getInputAttribute(i).getNumNominalValues() > 0) {
                    this.emin[i] = 0.0;
                    this.emax[i] = Attributes.getInputAttribute(i).getNumNominalValues() - 1;
                } else {
                    this.emin[i] = Attributes.getInputAttribute(i).getMinAttribute();
                    this.emax[i] = Attributes.getInputAttribute(i).getMaxAttribute();
                }
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    this.nominal[i] = true;
                    this.integer[i] = false;
                    continue;
                }
                if (Attributes.getInputAttribute(i).getType() == 1) {
                    this.nominal[i] = false;
                    this.integer[i] = true;
                    continue;
                }
                this.nominal[i] = false;
                this.integer[i] = false;
            }
            this.nClasses = 0;
            for (i = 0; i < this.nData; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (!this.missing[i][j]) continue;
                    this.X[i][j] = this.emin[j] - 1.0;
                }
                if (noOutputs) {
                    this.outputInteger[i] = 0;
                    this.output[i] = "";
                } else {
                    this.outputInteger[i] = (int)this.IS.getOutputNumericValue(i, 0);
                    this.output[i] = this.IS.getOutputNominalValue(i, 0);
                }
                if (this.outputInteger[i] <= this.nClasses) continue;
                this.nClasses = this.outputInteger[i];
            }
            ++this.nClasses;
            System.out.println("Number of classes=" + this.nClasses);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
        this.computeInstancesPerClass();
    }

    public String copyHeader() {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        return p;
    }

    public boolean hasRealAttributes() {
        return Attributes.hasRealAttributes();
    }

    public boolean hasNumericalAttributes() {
        return Attributes.hasIntegerAttributes() || Attributes.hasRealAttributes();
    }

    public boolean hasMissingAttributes() {
        return this.sizeWithoutMissing() < this.getnData();
    }

    public int sizeWithoutMissing() {
        int tam = 0;
        for (int i = 0; i < this.nData; ++i) {
            int j;
            for (j = 1; j < this.nInputs && !this.isMissing(i, j); ++j) {
            }
            if (j != this.nInputs) continue;
            ++tam;
        }
        return tam;
    }

    public int size() {
        return this.nData;
    }

    public void computeInstancesPerClass() {
        int i;
        this.instancesCl = new int[this.nClasses];
        this.frecuentCl = new double[this.nClasses];
        for (i = 0; i < this.nClasses; ++i) {
            this.instancesCl[i] = 0;
        }
        for (i = 0; i < this.getnData(); ++i) {
            int n = this.outputInteger[i];
            this.instancesCl[n] = this.instancesCl[n] + 1;
        }
        for (i = 0; i < this.nClasses; ++i) {
            this.frecuentCl[i] = 1.0 * (double)this.instancesCl[i] / (double)this.nData;
        }
    }

    public int numberInstances(int clas) {
        return this.instancesCl[clas];
    }

    public double frecuentClass(int clas) {
        return this.frecuentCl[clas];
    }

    public int numberValues(int attribute) {
        return Attributes.getInputAttribute(attribute).getNumNominalValues();
    }

    public String getOutputValue(int intValue) {
        return Attributes.getOutputAttribute(0).getNominalValue(intValue);
    }

    public int getTipo(int variable) {
        int n = Attributes.getAttribute(variable).getType();
        Attributes.getAttribute(0);
        if (n == 1) {
            return 1;
        }
        int n2 = Attributes.getAttribute(variable).getType();
        Attributes.getAttribute(0);
        if (n2 == 2) {
            return 0;
        }
        int n3 = Attributes.getAttribute(variable).getType();
        Attributes.getAttribute(0);
        if (n3 == 0) {
            return 2;
        }
        return 0;
    }

    public double[][] returnRanks() {
        double[][] rangos = new double[this.getnVars()][2];
        for (int i = 0; i < this.getnInputs(); ++i) {
            if (Attributes.getInputAttribute(i).getNumNominalValues() > 0) {
                rangos[i][0] = 0.0;
                rangos[i][1] = Attributes.getInputAttribute(i).getNumNominalValues() - 1;
                continue;
            }
            rangos[i][0] = Attributes.getInputAttribute(i).getMinAttribute();
            rangos[i][1] = Attributes.getInputAttribute(i).getMaxAttribute();
        }
        rangos[this.getnVars() - 1][0] = Attributes.getOutputAttribute(0).getMinAttribute();
        rangos[this.getnVars() - 1][1] = Attributes.getOutputAttribute(0).getMaxAttribute();
        return rangos;
    }

    public String[] names() {
        String[] names = new String[this.nInputs];
        for (int i = 0; i < this.nInputs; ++i) {
            names[i] = Attributes.getInputAttribute(i).getName();
        }
        return names;
    }

    public String[] clases() {
        String[] clases = new String[this.nClasses];
        for (int i = 0; i < this.nClasses; ++i) {
            clases[i] = Attributes.getOutputAttribute(0).getNominalValue(i);
        }
        return clases;
    }
}

