# vaccineff 1.0.1

`{vaccineff 1.0.1}` patches the package's tests to fix failing CRAN checks.

# vaccineff 1.0.0

`{vaccineff 1.0.0}` refactors the package's internal structure for better
maintainability.

## Breaking Changes

* **`estimate_vaccineff()`** replaces `effectiveness()`.
  - It returns an object of class `vaccineff`.
  - The `at` parameter must always be provided for accurate results.

* **`plot.vaccineff_data()`** replaces `plot_coverage()`.

* **`cohortdata`** has been simplified and reduced to improve examples and
  reduce computation time.



# vaccineff 0.0.4

## New Features

`{vaccineff 0.0.4}` simplifies data handling by using
[`linelist`](https://github.com/epiverse-trace/linelist) objects. Tags are
assigned to the outcome, censoring, and vaccine dates using the function
`make_vaccineff_data()`, reducing redundancy in function input parameters.

The new pipeline includes the following three functions and complementary
methods: `summary` and `plot`.

* **`make_vaccineff_data()`**: This function returns an S3 object of the class
  `vaccineff_data()` with the study's relevant information. It also allows
  the creation of a matched cohort to control for confounding variables by
  setting `match = TRUE` and passing the appropriate `exact` and `nearest`
  arguments. The method `summary()` can be used to check cohort
  characteristics, matching balance, and the sizes of matched, excluded,
  and removed populations.

* **`plot_coverage()`**: This function returns a plot of the vaccine coverage
  or cumulative coverage. If the population is matched, the plot includes
  the resulting count of doses after matching.

* **`effectiveness()`**: This function provides methods for estimating VE using
  the $HR$. A summary of the estimation is available via `summary()`, and
  a graphical representation of the methodology is generated by `plot()`.

## Breaking changes

The following functions are no longer accessible to users, but they are called
within `make_vaccineff_data()`:

* `make_immunization()`
* `match_cohort()`

The `plot()` method returns `log-log` and `survival` type plots when receiving
an object of type `effectiveness`. This deprecates the functions `plot_survival()`
and `plot_loglog()`.



# vaccineff 0.0.3
## New Features

This version introduces an iterative matching routine within `match_cohort()`.
After adjusting the exposure times of the pairs, new pairs are created between
the removed ones and the unmatched population. The new matches with inconsistent
exposure times are removed again, and the procedure is repeated until no new
pairs can be made. The usage of all the functions remains unchanged by this update.

# vaccineff 0.0.2
## New Features

The number of functions and steps for computing vaccine effectiveness has
been drastically reduced in `{vaccineff 0.0.2}`. The new pipeline for
estimation now consists of three main functions:

* **`make_immunization()`**: Prepares information on immunization dates
  and vaccine status. It can handle multiple columns for vaccine dates and
  custom vaccine statuses. In such cases, it returns the name of the column
  selected as immunizing and the custom name, if provided.

* **`match_cohort()`**: This function has been improved and generalized
  to reduce observation bias in cohorts. The default matching strategy is
  static, based on nearest and exact characteristics using Mahalanobis
  distance. The exposure times of the pairs are adjusted after matching. In
  future releases, rolling calendar matching will be introduced as a more
  accurate method to account for exposure times. The function returns an S3
  object of class `match`, from which a summary and balance of the cohorts
  can be printed using the `summary()` method. The matched cohort can be
  extracted using the `get_dataset()` method. The matched cohort contains
  all the necessary information to estimate vaccine effectiveness.

* **`effectiveness()`**: Receives a (matched) cohort and estimates vaccine
  effectiveness using the Hazard Ratio (HR). An S3 object of class
  `effectiveness` is returned, compatible with the `plot()` and `summary()`
  methods. Future releases will provide relative risk (RR) as an alternative
  for cases where the proportional hazards assumption is not satisfied.

## Breaking Changes

The following functions are no longer accessible to users. However, they
are called within `make_immunization()`:

* `get_immunization_date()`
* `get_immunization_dose()`
* `get_immunization_vaccine()`
* `set_status()`

Similarly, the `effectiveness()` function deprecates the use of
`coh_eff_noconf()`, and the `plot()` method now returns a log-log plot,
replacing the `plot_loglog()` function.
