/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Arrays;
import java.util.Objects;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCorelatedCriteriaCheck;
import org.ohdsi.circe.check.checkers.Comparisons;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.check.utils.CriteriaNameHelper;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.Death;

public class DeathTimeWindowCheck
extends BaseCorelatedCriteriaCheck {
    private static final String MESSAGE = "%s attempts to identify death event prior to index event. Events post-death may not be available";

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    @Override
    protected void checkCriteria(CorelatedCriteria criteria, String groupName, WarningReporter reporter) {
        String name = groupName + " " + CriteriaNameHelper.getCriteriaName(criteria.criteria);
        Operations.match(criteria.criteria).isA(Death.class).then(death -> Operations.match(criteria).when(c -> Comparisons.isBefore(c.startWindow)).then(() -> reporter.add(MESSAGE, name)));
    }

    @Override
    protected void internalCheck(CohortExpression expression, WarningReporter reporter) {
        super.internalCheck(expression, reporter);
        if (expression.additionalCriteria != null) {
            this.checkCriteriaList(expression.additionalCriteria.criteriaList, "additional rule", reporter);
        }
        this.checkCriteriaList(expression.primaryCriteria.criteriaList, "initial event", reporter);
    }

    private void checkCriteriaList(Object[] criteriaList, String groupName, WarningReporter reporter) {
        if (Objects.nonNull(criteriaList)) {
            Arrays.stream(criteriaList).forEach(c -> {
                Criteria criteria = null;
                if (c instanceof CorelatedCriteria) {
                    criteria = ((CorelatedCriteria)c).criteria;
                    this.checkCriteria((CorelatedCriteria)c, groupName, reporter);
                } else if (c instanceof Criteria) {
                    criteria = (Criteria)c;
                }
                if (Objects.nonNull(criteria)) {
                    this.checkCriteriaGroup(criteria, groupName, reporter);
                }
            });
        }
    }
}

